using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace JakeZoom {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry

        Texture2D jakeTexture;
        Rectangle jakeRect;

        int getPercentage(int percentage, int inputValue) {
            return (inputValue * percentage) / 100;
        }


        public Game1() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa treci
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            jakeRect = new Rectangle(
                    0, // wsprzdna pozioma lewego, grnego rogu
                    0, // wsprzdna pionowa lewego, grnego rogu
                    6000, // szeroko prostokta
                    4500); // wysoko prostokta

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            jakeTexture = this.Content.Load<Texture2D > ("jake");

            int displayWidth = GraphicsDevice.Viewport.Width;
            int displayHeight = GraphicsDevice.Viewport.Height;

            int scaledWidth = jakeTexture.Width * 10;
            int scaledHeight = jakeTexture.Height * 10;

            jakeRect = new Rectangle(
                    -(scaledWidth / 2) + (displayWidth / 2),
                    -(scaledHeight / 2) + (displayHeight / 2),
                    scaledWidth, scaledHeight);
        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            // Pozwala opuci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            if (jakeRect.Width > graphics.GraphicsDevice.Viewport.Width) {
                int widthChange = getPercentage(1, jakeRect.Width);
                int heightChange = getPercentage(1, jakeRect.Height);
                jakeRect.Width = jakeRect.Width - widthChange;
                jakeRect.Height = jakeRect.Height - heightChange;
                jakeRect.X = jakeRect.X + (widthChange / 2);
                jakeRect.Y = jakeRect.Y + (heightChange / 2);
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
            spriteBatch.Draw(jakeTexture, jakeRect, Color.White);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
